
; Scripts for Lotus Notes 5.0
;by A.G and D.B
;Copyright 1999, Henter-Joyce, Inc.


include "HjConst.jsh"
Include "magic.jsh"
include "HjGlobal.jsh"
include "NlNotes.jsh"
include "NlNotes.jsm"

Globals
	int globalEnterPressed,
	handle hWCheck,
	handle hContext, ; for the Context-Sensitive Help
	handle hReadWindow ,
	handle hBrowseWindow, ; to store location of the IE4 document window 
	int NotesFirstTime,
	int nSuppressEcho,
	int ignoreNewText,
	string GlobalTask,
	int iGlobObj, ; used by the ResetGlobal function for trapping Object Type Code information
	string sPrevObjName ; for ActiveItemChangedEvent,


Void Function ResetGlobal ()
let iGlobObj = GetObjectTypeCode ()
EndFunction

Void Function ResetGlobalWindows (handle hApp, handle hReal, handle hFocus)
	let GlobalPrevApp = hApp
	let GlobalPrevReal = hReal
	let GlobalFocusWindow = hFocus
EndFunction

void Function SayTreeViewLevel ()
var
	int iLevel,
	int iVerbosity
let iLevel = GetTreeViewLevel ()
let iVerbosity = GetVerbosity ()
If (iLevel != PreviousTreeviewLevel) then
	if iVerbosity == beginner then
		Say (Msg17, OT_STRING) ; "level "
	endif
	SayInteger(iLevel)
	let PreviousTreeViewLevel=GetTreeviewLevel()
EndIf
EndFunction

Void Function SayTreeViewItem ()
var
	handle hWnd,
	int iControl,
	string sObjName,
	string sObjState,
	string sObjValue,
	string sLine
let hWnd = GetCurrentWindow ()
let iControl = GetControlId (hWnd)
let sObjName = GetObjectName ()
let sObjState = GetObjectState ()
let sObjValue = GetObjectValue ()
SayTreeviewLevel ()
If (iControl == iDGoToTree) then
	Say (sObjName, OT_TEXT)
	If (! StringContains (sObjState, msg135)) then
		Say (msgNewLine, OT_BUFFER)
		Say (sObjState, OT_STATUS)
	EndIf
	return
EndIf
If (StringContains (sObjState, msg135)) then
	Say (sObjState, OT_STATUS)
EndIf
Say (sObjValue, OT_STATUS)
Say (msgNewLine, OT_BUFFER)
Say (sObjName, OT_TEXT)
If (! StringContains (sObjState, msg135)) then
	Say (sObjState, OT_STATUS)
EndIf
;for the Attachment Graphic,
; as this is not picked up by MSAA
let sLine = GetLine ()
If (StringContains (sLine, msg102)) then
	Say (msgNewLine, OT_BUFFER)
	Say (msg103, OT_STATUS); "Has Attachment"
EndIf
EndFunction

Int Function DoCustomEdits ()
var
	int iBool,
	handle hWnd,
	handle hReal,
	string strText,
	string sClass,
	string sAppName ; Avoid the message headers
If (DialogActive ()) then
	let iBool = false
	Return iBool
EndIf
If (GlobalMenuMode > 0) then
	let iBool = 0
	Return iBool
EndIf
let hWnd = GetCurrentWindow ()
let hReal = GetRealWindow (hWnd)
let sAppName = GetWindowName (GetAppMainWindow (hWnd))
; wn10 = "New Memo - Lotus Notes"
If (sAppName == wn10) then
	let iBool = false
	Return iBool
EndIf
let sClass = GetWindowClass (hWnd)
If (sClass != wcNoteEdit) then
	let iBool = false; 
	Return iBool
EndIf
SayWindowTypeAndText (hWnd)
let iBool = true
return iBool
EndFunction

Int Function IsEmbeddedControl ()
; Known object types are handled here
; to assist in onsistency of speech for
; these object types
var
	int iObjType,
	int iMSAAMode,
	handle hWnd,
	string sClass
let iObjType = GetObjectTypeCode ()
let iMSAAMode = GetJcfOption (OPT_MSAA_MODE)
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (hWnd)
;Standard window types do not function properly when spoken as embedded controls
if (iMSAAMode == 0) then
	return false
EndIf
;The following types are not embedded controls for the purposes of this function
If (iObjType == WT_UNKNOWN) then
	return false
EndIf
If (iObjType == WT_EDIT) then
	return false
EndIf
;The following types must be returned as valid embedded controls
; or there will be major focus problems when attempting to read them
if (iObjType == WT_LINK) then
	return true
EndIf
If (iObjType == 53) then ; document links 
	Return true
EndIf
If (iObjType == WT_LISTBOX) then
	Return true
EndIf
If (iObjType == WT_COMBOBOX) then
	Return false
EndIf
If (iObjType == WT_EXTENDEDSELECT_LISTBOX || iObjType == WT_MULTISELECT_LISTBOX) then
	Return false
EndIf
If (iObjType == WT_TREEVIEW || iObjType == WT_TREEVIEWITEM) then
	Return false
EndIf
If (iObjType == WT_LISTVIEW) then 
	Return false
EndIf
If (sClass == wcDocClass) ||
(sClass == wcProperties) ||
(sClass == wcProperties2) then
	;Return true in the following if/Elif conditions
	If iObjType == WT_BUTTON then
		Return true
	ElIf iObjType == WT_RADIOBUTTON then
		Return true
	ElIf iObjType == WT_CHECKBOX then
		Return true
	Else
		Return false
	EndIf
EndIf
EndFunction

HANDLE Function FindEmbeddedWindow (handle hWnd, string sClass)
var
	int iCounter,
	string sCompareClass
let iCounter = 0
let sCompareClass = GetWindowClass (hWnd)
;Set the counter higher if need be, but 
;I haven't found more than four levels deep where we need to use this as opposed to FindDescendant or FindTopLevel
While (sCompareClass != sClass && iCounter <= 10) 
	let hWnd = GetFirstChild (hWnd)
	let sCompareClass = GetWindowClass (hWnd)
	let iCounter = iCounter + 1
EndWhile
If (hWnd) then
	return hWnd
Else
	return 0
EndIf
EndFunction

Void Function ValueChangedEvent (handle hwnd, int objId, int childId, int nObjType, string sObjName, string sObjValue)
var
	handle hCurrent,
	string sCurrentClass,
	string sParentClass,
	string sHwndClass,
	string sHwndText
let hCurrent = GetCurrentWindow ()
let sCurrentClass = GetWindowClass (hCurrent)
let sParentClass = GetWindowClass (GetParent (GetCurrentWindow ()))
let sHwndClass = GetWindowClass (hWnd)
let sHwndText = GetWindowText (hWnd, false)
if (sCurrentClass == wcTaskList) then
	return
EndIf
If (nObjType == WT_HOTKEY) then
	If (! DialogActive ()) then
		If (sCurrentClass != wcTaskList) then
			Say (sObjValue, OT_MESSAGE)
			return
		EndIf
	EndIf
EndIf
; for the bookmark HotKeys in Lotus
; as these hot keys are returned in the Object Name, and not the value
;Add code for exceptions here if there Objects with no type that have a name and do not return a value should not be spoken 
If (nObjType == WT_UNKNOWN) then
	If (sObjValue == "") &&
	(sObjName > "") then
		Say (sObjName, OT_MESSAGE)
	EndIf
EndIf
If (sCurrentClass == wcStatus) then
	If (sParentClass == wcFrameParent) then
			Say (sObjValue, OT_CONTROL_NAME)
			Return
	EndIf
EndIf
If (sHwndClass == wcStatus) then
	;msg106 = "%"
	If(StringContains (sHwndText, msg106)) then
		Return
	EndIf
	If (sCurrentClass == IE4Class) then
		return
	EndIf
	Say (sObjValue, OT_CONTROL_NAME)
	let GlobalTask = sObjValue
	Return
EndIf
EndFunction

Void Function MenuModeEvent (handle WinHandle, int mode)
;To keep the hot keys from being spoken when holding down the alt key
If GlobalMenuMode == 0 then
	StopSpeech ()
EndIf
MenuModeEvent (WinHandle, mode)
EndFunction

HANDLE Function GetRealWindow (handle hWnd)
var
	int iSubtypeCode,
	handle WinHandle,
		handle hParent,
	handle RealWindow
let WinHandle = hWnd
let hParent = GetParent (GetParent (hWnd))
If (hParent) then
	let iSubtypeCode = GetWindowSubtypeCode (hParent)
	If (iSubtypeCode == WT_DIALOG) then
		let RealWindow = hParent
		return RealWindow
	EndIf
EndIf
let iSubtypeCode = GetWindowSubtypeCode (WinHandle)
; search upward the hierarchy to get the handle of the highest 
;dialog window
while (WinHandle)
	let iSubtypeCode = GetWindowSubtypeCode (winHandle)
	if (iSubtypeCode == WT_DIALOG) then
		let RealWindow = WinHandle
	EndIf
	let WinHandle = GetParent (WinHandle)
EndWhile
If (RealWindow) then ; Dialog is active
	return RealWindow
Else
	return GetRealWindow (hWnd)
EndIf
EndFunction

Void Function SpellWordHook (string ScriptName)
var
	 int iObjType,
	string sObjName
let iObjType = GetObjectTypeCode ()
let sObjName = GetObjectName ()
if (ScriptName == "SayNextWord") then
	NextWord ()
	If (iObjType == WT_TABCONTROL) then
		SpellString (GetObjectName ())
		return false
	ElIf GlobalTask > "" then
		SpellString (GlobalTask)
	Return false
	Else
		SpellWord ()
		return false
	EndIf
EndIf
if (ScriptName == "SayPriorWord") then
	PriorWord ()
	If (iObjType == WT_TABCONTROL) then
		SpellString (sObjName)
		return false
	ElIf GlobalTask > "" then
		SpellString (GlobalTask)
	Return false
	Else
		SpellWord ()
		return false
	EndIf
EndIf
RemoveHook (HK_SCRIPT, "SpellWordHook")
return true
EndFunction

Void Function AutoFocusBrowser ()
var
	int iTop,
	int iLeft,
	string sClass
let sClass = GetWindowClass (hBrowseWindow)
If (hBrowseWindow == GetFocus ()) then
	Say (msg29, OT_MESSAGE); "The browser window already has focus"
	return
EndIf
If (! IsWindowObscured (hBrowseWindow)) then
	If (sClass == IE4Class) then
		SaveCursor ()
		JawsCursor ()
		let iTop = GetWindowTop (hBrowseWindow)
		let iLeft = GetWindowLeft (hBrowseWindow)
		MoveTo (iLeft+3, iTop+3)
		Pause ()
		;LeftMouseButton ()
		RoutePcToJaws ()
		;RestoreCursor ()
		;SayWindow (hBrowseWindow, Read_Everything)
		;Refresh ()
	Else
		Say (msg28, OT_MESSAGE); "Web page not found"
	EndIf
	Return;
EndIf
EndFunction

Void Function SayAllStoppedEvent ()
var
	string sCurrentClass
let sCurrentClass = GetWindowClass (GetCurrentWindow ())
; To read the text of the help topic
If ((hReadWindow) &&
(IsWindowVisible (hReadWindow))) then
	If (IsJawsCursor ()) then
		RestrictCursor (Off)
		Return
	EndIf
EndIf
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes,
int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
; Handles all newly written text.  If the text is contained in a
; frame, then the frame name is passed as a parameter
var
	int iTime,
	handle hFocus,
	string sClass,
	string sFocusClass,
	string sHwndClass,
	string sAppWinName
if (ProcessSelectText(nAttributes,buffer)) then
	return
endif
if (sFrameName == "") then
	; this text is not associated with a frame
	If (IgnoreNewText) then
		Return
	EndIf
	let sClass = GetWindowClass (hWnd)
	If (sClass == "") then
		Return
	EndIf
	If (sClass == wcTreeParent) then
		Return
	EndIf
	If (sClass == wcNotesClass) then
		If (StringLength (sClass) == 5) then
			Return
		EndIf
	EndIf
	If (StringContains (sClass, "NotesTab")) then
		Return
	EndIf
		let sHwndClass = GetWindowClass (hWnd)
	If (sHwndClass == wcDocClass2) then
		If (StringLength (sHwndClass) == 14) then
			let hContext = hWnd
		EndIf
	EndIf
	If (GlobalMenuMode == 0) then
		let hFocus = GetFocus ()
		If (StringLength (sClass) == 13) then
			If (sClass == wcDocClass) then
				If (! CaretVisible ()) ||
				; to function even when the link element is the first item in the document
				(iGlobObj == 53) then
					let hReadWindow = hWnd
					If (iGlobObj == WT_CHECKBOX) then
						Return
					EndIf
					If (iGlobObj == WT_BUTTON) then
						return
					EndIf
					If (iGlobObj == WT_RADIOBUTTON) then
						return
					EndIf
					If (iGlobObj == WT_LISTBOX) then
						return
					EndIf
					If (iGlobObj == WT_BITMAP) then
						Return
					EndIf
					If (iGlobObj == WT_COMBOBOX) then
						return
					EndIf
					If (iGlobObj == WT_COMBOBOX) then
						return
					EndIf
					If (hWnd == hFocus) then
						; wn2 = "Welcome - Lotus Notes"
						let sAppWinName = GetWindowName (GetAppMainWindow (hWnd))
						If (sAppWinName != wn2) then
							let sFocusClass = GetWindowClass (hFocus)
							If (StringLength (sFocusClass) != 13) then
								Return
							EndIf
							Say (buffer, OT_BUFFER)
						EndIf
					EndIf
				EndIf
			EndIf
			; Speak the Browser window if it already has focus
			; for example when doing a PageDown
			If (hWnd == hFocus) then
			If (sHwndClass == IE4class) then
				let hReadWindow = hWnd
				Say (buffer, OT_BUFFER)
				Return
			EndIf
		EndIf
	EndIf
	EndIf
	if (nAttributes& ATTRIB_HIGHLIGHT) then 
		SayHighlightedText(hwnd,buffer)
	else 
		SayNonHighlightedText(hwnd,buffer) 
	endif
else
  ; this text is associated with a frame
	if (nEcho == ECHO_NONE) then 
		return 
	endif  ; frame is being silenced
	if (nEcho  == ECHO_ALL || 
	(nAttributes & ATTRIB_HIGHLIGHT)) then
	; if FrameEcho is set to all or the text being written is highlighted
		Say (buffer, ot_buffer)
	Endif
endif
EndFunction

Void Function AutoStartEvent ()
If (NotesFirstTime ==0) then
	let NotesFirstTime = 1
	SayExtendedHelpHotKey ()
	Say (msg92+GetScriptKeyName ("ScreenSensitiveHelp"), OT_HELP); "For ScreenSensitiveHelp, press"
	Say (msg93+GetScriptKeyName ("HotKeyHelp"), OT_HELP); "For Jaws Hot keys, press"
	Say (msg94+GetScriptKeyName ("WindowKeysHelp"), OT_HELP); "For a list of Windows shortcut keys in Lotus Notes, press"
EndIf
EndFunction

Void Function AutoFinishEvent ()
RestrictCursor (off)
PcCursor ()
SetJcfOption (OPT_MSAA_MODE, 0)
EndFunction

Void Function BrailleBuildLine ()
var
	handle hwnd,
	int ObjectTypeCode,
	int iControl,
	int WindowTypeCode,
	string sObjValue,
	string sObjName
if MenusActive () then
	if !GlobalPixelsPerSpace then
		let GlobalPixelsPerSpace=GetJcfOption (OPT_PIXELS_PER_SPACE)
	EndIf
	SetJcfOption (OPT_PIXELS_PER_SPACE, 99)
	BrailleBuildMenu()
	Return TRUE
EndIf
let hwnd = GetFocus()
let ObjectTypeCode = GetObjectTypeCode ()
let iControl = GetControlID (hWnd)
let WindowTypeCode = GetWindowSubTypeCode (hwnd)
let sObjValue = GetObjectValue ()
let sObjName = GetObjectName ()
if DialogActive () then
	if !GlobalPixelsPerSpace then
		let GlobalPixelsPerSpace=GetJcfOption (OPT_PIXELS_PER_SPACE)
	EndIf
	SetJcfOption (OPT_PIXELS_PER_SPACE, 99)
	BrailleBuildDialog(GetRealWindow(hwnd))
	return TRUE
EndIf
If (ObjectTypeCode == WT_LISTBOX) &&
(! DialogActive ()) &&
(! iControl) then
	if !GlobalPixelsPerSpace then
		let GlobalPixelsPerSpace=GetJcfOption (OPT_PIXELS_PER_SPACE)
	EndIf
	SetJcfOption (OPT_PIXELS_PER_SPACE, 99)
	;BrailleBuildOther (WT_LISTBOX)
	BrailleAddString (sObjName, 0,0,0)
	BrailleAddString (msg95, 0,0,0); " list box"
	BrailleAddString (sObjValue, 0,0,0)
	return true
EndIf
if WindowTypeCode == WT_LISTVIEW ||
ObjectTypeCode == WT_LISTVIEW ||
WindowTypeCode == WT_LISTBOX ||
ObjectTypeCode == WT_LISTBOX ||
WindowTypeCode == WT_TREEVIEW ||
ObjectTypeCode == WT_TREEVIEW ||
ObjectTypeCode == WT_TREEVIEWITEM ||
WindowTypeCode == WT_STARTBUTTON ||
ObjectTypeCode == WT_STARTBUTTON ||
WindowTypeCode == WT_DESKTOP ||
ObjectTypeCode == WT_DESKTOP ||
WindowTypeCode == WT_TASKBAR ||
ObjectTypeCode == WT_TASKBAR
then
	if !GlobalPixelsPerSpace then
		let GlobalPixelsPerSpace=GetJcfOption (OPT_PIXELS_PER_SPACE)
	EndIf
	SetJcfOption (OPT_PIXELS_PER_SPACE, 99)
	If ObjectTypeCode > 0 then
		BrailleBuildOther(ObjectTypeCode)
		Return TRUE
	ElIf WindowTypeCode > 0 then
		BrailleBuildOther (WindowTypeCode)
		Return true
	Else
		Return false
	EndIf
EndIf
if GlobalPixelsPerSpace then
	SetJcfOption (OPT_PIXELS_PER_SPACE, GlobalPixelsPerSpace)
EndIf
let GlobalPixelsPerSpace = 0
return FALSE
EndFunction

Void Function BrailleBuildOther (int WindowSubTypeCode)
var
	string sWinType,
	string sObjType,
	string Buffer
let sWinType = GetWindowType (GetFocus ())
let sObjType = GetObjectType ()
if WindowSubTypeCode == 	WT_DESKTOP then
	BrailleAddString (msg137, 0,0,0) ; "Desktop"
	BrailleAddFocusItem ()
	return TRUE
elif WindowSubTypeCode == WT_TASKBAR then
	BrailleAddString (msg138, 0,0,0) ; "Task Bar"
	BrailleAddFocusLine()
	return TRUE
elif WindowSubTypeCode == WT_STARTBUTTON then
	BrailleAddFocusItem()
	return TRUE
elif WindowSubTypeCode == WT_COMBOBOX ||
	WindowSubTypeCode == WT_ListBOX ||
	WindowSubTypeCode == WT_LISTVIEW ||
	WindowSubTypeCode ==	WT_EXTENDEDSELECT_LISTBOX ||
	WindowSubTypeCode == WT_TREEVIEW ||
	WindowSubTypeCode == WT_TREEVIEWITEM ||
	WindowSubTypeCode == WT_button then
	if GetJcfOption (OPT_BRL_Verbosity)==0 then
		let Buffer = sWinType
		If (StringContains (buffer, msg139)) then
			let buffer = sObjType
		EndIf
		If (stringContains (buffer, msg136)) then
			let buffer = msg23
		EndIf
		BrailleAddString (Buffer, 0, 0, 0)
	EndIf
	BrailleAddFocusItem()
	return TRUE
else
	return FALSE
EndIf
EndFunction

Void Function ActiveItemChangedEvent (handle curHwnd, int curObjectId, int curChildId, 
	handle prevHwnd, int prevObjectId, int prevChildId)
var
	handle hNext,
	handle hPrior,
	int iControl,
	string sClass,
	string sObjName,
	string sObjValue,
	string sObjType,
	string sAppName,
	string sGraphName
let globalEnterPressed = FALSE
ResetGlobal ()
let iControl = GetControlId (GetCurrentWindow ()) 
; for Tree views
If ((iGlobObj == WT_TREEVIEW) ||
(iControl == iDGoToTree) ||
(iGlobObj == WT_TREEVIEWITEM)) then
	PcCursor ()
	SayTreeViewItem ()
	;SayObjectActiveItem () ; not used here now to improve performance, as performance improvement was insignificant
	Return
EndIf
let hNext = GetNextWindow (CurHwnd)
let hPrior = GetPriorWindow (CurHwnd)
let sClass = GetWindowClass (CurHwnd)
let sAppName = GetWindowName (GetAppMainWindow (CurHwnd)) 
let sGraphName = "" ; will store name of message status graphic in Tree view logic
; to enable the speaking of links in document classes
;typically read like caretless window
If (sClass == wcDocClass) then
	If (! hNext) then
		If (! hPrior) then
			If (iGlobObj != WT_CHECKBOX) &&
			(iGlobObj != WT_BUTTON) then
				let sObjValue = GetObjectValue ()
				Say (sObjValue, OT_CONTROL_NAME)
				return
			EndIf
		EndIf
	EndIf
EndIf
let sObjName = GetObjectName ()
If (sPrevObjName == sObjName) then
	Return
EndIf
SaveCursor ()
PCCursor ()
;For Calendar View
let sObjType = GetObjectType () 
If (sObjType == wn18) then
	SayObjectActiveItem ()
	Return
EndIf
;for the Text Properties boxes
If (sClass == wcProperties) ||
(sClass == wcProperties2) then
	If (iGlobObj == WT_TABCONTROL) THEN
		SayObjectActiveItem ()
		Return
	EndIf
	If (iGlobObj == WT_LISTBOX) ||
	(iGlobObj == WT_LISTBOXITEM) then
			SayObjectActiveItem ()
		let sPrevObjName = sObjName
		Return
	EndIf
	let sPrevObjName = sObjName
	Return
EndIf
if (sClass == wcDocClass) then
	If (iGlobObj != wt_edit) then
		SayObjectActiveItem ()
	let sPrevObjName = sObjName
		Return
	EndIf
	;For caretless messages
	If (! CaretVisible ()) then
		let sObjValue = GetObjectValue ()
		Say (sObjValue, OT_STRING)
		let sPrevObjName = sObjName
		Return
	EndIf
	;wn10 = "New Memo - Lotus Notes"
	If (sAppName != wn10) ||
	(iGlobObj != WT_EDIT) then
		SayObjectActiveItem ()
		let sPrevObjName = sObjName
		Return
	EndIf
	;For the multiple lines in Message Body window
	; to prevent extra chatter from MSAA and at the same time keep the prompts reading
	;wn9 = "Body of Message"
	If (sObjName == wn9) then
		;To handle embedded objects
		If (iGlobObj == WT_BITMAP) then
			Say (msg6, OT_CONTROL_NAME); "embedded"
			SayFocusedObject ()
			Return
		EndIf
		Return
	EndIf
	;wn10 = "New Memo - Lotus Notes"
	If (sAppName == wn10) then
		;for Mail and Memmo windows
		;wn12 = "Subject of memo"
		If (sObjName == wn12) then
			Say (msg1, OT_CONTROL_NAME); "SUBJECT:"
			Say (msg5, OT_CONTROL_NAME)	; "edit"
			Say (GetObjectValue (), OT_STRING)
		;wn13 = "List of people to send a copy of the memo."
		ElIf (sObjName == wn14) then 
			Say (msg2, OT_CONTROL_NAME); "BCC:"
			Say (msg5, OT_CONTROL_NAME); "edit"
			Say (GetObjectValue (), OT_STRING)
		ElIf (sObjName == wn13) then
			Say (msg3, OT_CONTROL_NAME);"Cc"
			Say (msg5, OT_CONTROL_NAME); "edit"
			Say (GetObjectValue (), OT_STRING)
		;wn15 = "List of primary people to send memo"
		ElIf (sObjName == wn15) then
			Say (msg4, OT_CONTROL_NAME);"to:"
			Say (msg5, OT_CONTROL_NAME); "edit"
			Say (GetObjectValue (), OT_STRING)
		;wn16 = "body of message"
		ElIf (sObjName == wn16) then
			Say (msg5, OT_CONTROL_NAME); "edit"
			let sPrevObjName = sObjName
			Return
		EndIf; End of message prompts
		let sPrevObjName = sObjName
		Return
	EndIf ; End of Object TypeCode check 
Else
	SayObjectActiveItem ()
EndIf; End of Class check
If (iGlobObj == WT_LISTBOX) ||
(iGlobObj == WT_EDITCOMBO) ||
(iGlobObj == WT_COMBOBOX) then
	let sObjName = GetObjectName ()
	If (sObjName == sPrevObjName) then
		let sObjValue = GetObjectValue ()
		Say (sObjValue, OT_LINE)
		let sPrevObjName = sObjName
		Return
	Else
		SayObjectActiveItem ()
		let sPrevObjName = sObjName
		Return
	EndIf
EndIf
SayObjectActiveItem ()
let sPrevObjName = sObjName
RestoreCursor ()
EndFunction

Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	int iWinType,
	int iControl,
	int iColorBack,
	int iMSAAMode,
	handle hFocus,
	handle RealWindow,
	handle AppWindow,
	string sObjName,
	string sClass,
	string sFocusClass,
	string sCurrentClass,
	string sCurParentClass,
	string sPrevClass,
	string sChildClass,
	string sRealClass,
	string sPrevRealClass,
	string sParentClass,
	string sLine,
	string sWord,
	string sAppName, 
	string sPrevAppName,
	string sPrevRealName,
	string RealName
let globalEnterPressed = FALSE
SetJcfOption (OPT_MSAA_MODE, 2)
; Handle Menus by Default
If (GlobalMenuMode >= 1) then
	SayObjectActiveItem ()
	Return ; Do not let confusion between AppClass and menu bar
EndIf
let hFocus = GetFocus ()
let RealWindow = GetRealWindow (FocusWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
let sAppName = GetWindowName (AppWindow)
let sPrevAppName = GetWindowName (GlobalPrevApp)
let RealName = GetWindowName (RealWindow)
let sPrevRealName = GetWindowName (GlobalPrevReal)
let sClass = GetWindowClass (FocusWindow)
If (sClass == "") then
	ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)
	Return
EndIf
If (GlobalPrevApp != AppWindow && AppWindow != FocusWindow) then
	; we've switched to a different app main window,
	; and it does not have the focus, so announce it
	If (GlobalMenuMode == 0) then
		SayWindowTypeAndText (AppWindow)
	EndIf
EndIf
If ((sPrevRealName != RealName) || ; name has changed
(GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow) && (RealWindow != FocusWindow)) then
		SayWindowTypeAndText (RealWindow)
	EndIf
EndIf
let iWinType = GetWindowSubtypeCode (FocusWindow)
If (sClass == wcNoteEdit) ||
(iWinType == WT_EDITCOMBO) then
	SetJcfOption (OPT_MSAA_MODE, 0)
	SayFocusedWindow ()
	ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
	return
EndIf
; Speak the title of the line view
; Because above conditions will not cause title to speak when it gains focus
If (sClass == wcTreeParent) then
	;wn19 = "Calendar",
	If (!StringContains (sAppName, wn19)) then ; The Calendar table overtalks otherwise, don't slow down performance by checking object
		SayWindowTypeAndText (AppWindow)
		SayObjectTypeAndText ()
	Else
		SayObjectActiveItem ()
	EndIf
	ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
	Return
EndIf
If (DoCustomEdits ()) then
ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)
	Return
EndIf
let iGlobObj = GetObjectTypeCode ()
let sClass = GetWindowClass (FocusWindow)
let sFocusClass = GetWindowClass (GetFocus ())
let sCurrentClass = GetWindowClass (GetCurrentWindow ())
let sCurParentClass = GetWindowClass (GetParent (GetCurrentWindow ()))
let sPrevClass = GetWindowClass (PrevWindow)
let sChildClass = GetWindowClass (GetFirstChild (FocusWindow))
let sRealClass = GetWindowClass (RealWindow)
let sPrevRealClass = GetWindowClass (GlobalPrevReal)
let sParentClass = GetWindowClass (GetParent (FocusWindow))
let IgnoreNewText = false
;Stop overchatter when moving between apps using alt+tab in Windows 9X
;Removing this code block will result in an infinite loop of annoying speech
If (sClass == wcTaskList) ||
((sPrevClass == wcTaskList) &&
(sClass == wcDocClass)) then
	ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
	return
EndIf
If (GlobalMenuMode == 0) then
	If (iWinType == WT_EDIT) ||
		(iGlobObj == WT_EDIT) ||
		(sClass == wcDocClass) then
		If (sAppName != sPrevAppName) then
			SayWindowTypeAndText (AppWindow)
		EndIf
	EndIf
EndIf
If IsEmbeddedControl () then
	SayObjectActiveItem ()
	ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
	Return
EndIf
let sObjName = GetObjectName ()
If (iGlobObj == wt_bitmap) then
	If (! sObjName) then
	Say (msg119, OT_CONTROL_NAME)
	Else
		SayObjectActiveItem ()
	EndIf
	ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
	Return
EndIf
If (! CaretVisible ()) then
	If (sFocusClass == wcDocClass) then
		If (sChildClass == wcIEParent) then
			let hBrowseWindow = FindEmbeddedWindow (FocusWindow, IE4Class)
			If (hBrowseWindow) then
				AutoFocusBrowser ()
				ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
				return
			EndIf
		EndIf
		If (! IsEmbeddedControl ()) then
			SayWindowTypeAndText (AppWindow)
		Else
			If (sClass != sPrevClass) then
				SayObjectActiveItem ()
				ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
				Return
			EndIf
		EndIf
		ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
		Return
	EndIf
Else; if caret is present
	If (sClass == wcDocClass) then
		SayObjectActiveItem ()
		ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
		return
	EndIf
EndIf
If (iGlobObj) &&
(iGlobObj != WT_BITMAP) then
	let GlobalTask = ""
EndIf
; in the case that the first test failed
; especially in some cases with Windows 9X
If (sClass == wcIEParent) ||
(sClass == WCIEEmbed) ||
(sChildClass == wcIEParent) then
	let hBrowseWindow = FindEmbeddedWindow (FocusWindow, IE4Class)
	If (hBrowseWindow) then
		AutoFocusBrowser ()
	EndIf
EndIf
If (sClass == wcTreeParent) then
	let GlobalTask = ""
EndIf
; for edit fields found in the Properties Box 
If (sClass == wcEdit) &&
(sParentClass == wcProperties2) then
	;SetJcfOption (OPT_MSAA_MODE, 2)
	SayFocusedWindow ()
	ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
	Return
EndIf
;For some list boxes found in the Properties boxes
If (iGlobObj == WT_LISTBOX) &&
(sClass == wcProperties2) then
	; Some List Boxes in these Database and Document Properties boxes have the word 
;"listbox" as a part of the name
	; thus, the attempt here to keep Jaws from saying "listbox" twice
	;wn17 = "listbox"
	If (StringContains (sObjName, wn17)) then
		Say (sObjName, OT_CONTROL_NAME);
	Else
		SayObjectTypeAndText ()
	EndIf
	let sLine = GetLine ()
	Say (sLine, OT_TEXT)
	ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
	Return
EndIf
let iControl = GetControlId (FocusWindow)
; For the Calendar Table view
If (iControl) then
	If (! iGlobObj ) then
		If (sClass == wcTreeParent) then
			If (StringContains (sAppName, wn19)) then ; "Calendar"
				If (sPrevClass != wcTreeParent) then
					Say (msg117, OT_HELP); "Calendar Line View"
					SayObjectActiveItem ()
				Else
					SayLine ()
				EndIf
			EndIf
			ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
			Return
		EndIf
	EndIf
EndIf
;For the Visual Display of the calendar
If (sChildClass == wcCalClass) then
	Say (msg118, OT_HELP); "Date Picker"
EndIf
If (sCurrentClass == wcStatus) then
	If (sCurParentClass == wcFrameParent) then
		Say (GetObjectValue (), OT_CONTROL_NAME)
		ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
		Return
	EndIf
EndIf
;The following window types function much better with MSAA off
If ((DialogActive ()) ||
(sClass == wcTaskList) ||
(iWinType == WT_COMBOBOX) ||
(sClass == wcPassword) ||
(sClass == wcEdit) ||
(sRealClass == wcDialog)) &&
;wn3 = "Go To"
(RealName != wn3) then
	SetJcfOption (OPT_MSAA_MODE, 0)
Else
	SetJcfOption (OPT_MSAA_MODE, 2)
EndIf
;Turn MSAA back on if using Notes' Native classes
If (sClass == wcDocClass) ||
(sClass == wcGoToTree) ||
(sClass == wcTreeParent) then
	SetJcfOption (OPT_MSAA_MODE, 2)
EndIf
;For the SpellCheck dialog
If (DialogActive ()) then
	If (sClass == wcSplash) then
		SayWindow (FocusWindow, Read_everything)
	EndIf
	;wn1 = "Spell Check"
	If(RealName == wn1) then
		If (iControl == iD_Replace_Edit) then
			PerformScript ReadMistakeAndSuggestion()
			ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
			Return
		EndIf
		SayWindowTypeAndText (hFocus)
		ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
		Return
	EndIf
	let iMSAAMode = GetJcfOption (OPT_MSAA_MODE)
	If (iMSAAMode == 0) then
		SayWindowTypeAndText (FocusWindow)
		ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
		Return
	EndIf
EndIf
;For Edit fields without MSAA prompts
If (iGlobObj == WT_EDIT) then
	If (iWinType != WT_EDITCOMBO) then
		If (sClass != wcNoteEdit) then
			If (GetWindowClass (FocusWindow) != wcDocClass) then ; don't do this in Notes Native Edits where custom control are embedded
				If(! sObjName) then
					If (sClass == wcEdit) then
						PerformScript SayWindowPromptAndText ()
						ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
						Return
					EndIf
					If (CaretVisible ()) then
						SaveCursor ()
						RouteInvisibleToPc ()
						InvisibleCursor ()
						JawsHome ()
						SayChunk ()
						RestoreCursor ()
					Else
						SayChunk ()
					EndIf; End of caret check
				EndIf
			Say (GetWindowType (GetCurrentWindow ()), OT_CONTROL_NAME)
			EndIf
		EndIf
	EndIf
EndIf
let iColorBack = GetColorBackground ()
If (sFocusClass == wcDocClass) then
	If (iGlobObj == 53) &&
	(iColorBack == RGBStringToColor ("055096094")) ||
	(iColorBack == RgbStringToColor ("115156198")) then
		Say (msg98, OT_CONTROL_NAME); "Graphic frame"
		let sWord = GetWord ()
		If (sWord > "") then
			SayWord ()
			ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
			Return
		EndIf
	EndIf
	If (iGlobObj == WT_BITMAP) &&
	(! CaretVisible ()) then
		;wn20 = "New Contact"
		If (StringContains (sAppName, wn20)) then
			Say (msg119, OT_CONTROL_NAME); "picker"
		EndIf
		If (sCurParentClass == wcTreeParent) then
			;wn7 = "New Calendar Entry"
			If (! StringContains (RealName, wn7)) &&
			;wn20 = "New Contact"
			(! StringContains (RealName, wn20)) then
				Say (msg99, OT_CONTROL_NAME); "Switcher Frame"
				if (sAppName == wn2) then ; "Welcome - Lotus Notes"
					SaveCursor ()
					PcCursor ()
					SayLine ()
					RestoreCursor ()
				Else
					SaveCursor ()
					RouteInvisibleToPc ()
					InvisibleCursor ()
					JawsPageDown ()
					JawsEnd ()
					PriorChunk ()
					let GlobalTask = GetChunk ()
					Say (GetChunk (), OT_CONTROL_NAME)
					RestoreCursor ()
				EndIf
				ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
				Return
			Else
				Say (msg119, OT_CONTROL_NAME); "picker"
			EndIf
		EndIf
		ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
		Return
	EndIf
	If (FocusWindow != PrevWindow) then
		SayObjectActiveItem ()
	EndIf
EndIf
SayFocusedWindow ()
ResetGlobalWindows (AppWindow, RealWindow, FocusWindow)	
EndFunction

Void Function SayNonHighlightedText (handle hWnd, string buffer)
var
	handle hReal,
	handle hFocus,
	int iControl,
	string sRealClass,
	string sHwndClass,
	string sCurrentClass, 
	string sRealName
let hReal = GetRealWindow (GetCurrentWindow ())
let hFocus = GetFocus ()
let sRealClass = GetWindowClass (hReal)
let iControl = GetControlId (hWnd)
let sRealName = GetWindowName (hReal)
let sCurrentClass = GetWindowClass (GetCurrentWindow ())
let sHwndClass = GetWindowClass (hWnd)
; to allow reading of the Task List
If (sHwndClass == wcTaskList) then
	StopSpeech ()
	Say (buffer, OT_BUFFER)
	Return
EndIf
;To prevent extraneous overReading of text that succeeds the embedded object in a Document class
; the problem object types contain the type code of WT_BITMAP and are associated with files, links and hot spots. 
If (sCurrentClass == wcDocClass) then
	If (iGlobObj == WT_BITMAP) then
		Return
	EndIf
EndIf
;Stop OverChatter in dialog boxes
If (sRealClass == wcDialog) then
	;wn1 = "Spell Check"
	If (sRealName == wn1) then
		If (iControl == iD_Replace_Edit) then
			If (hWnd == hFocus) then
				PerformScript ReadMistakeAndSuggestion ()
			EndIf
		EndIf
		Return
	EndIf
EndIf
SayNonHighlightedText (hWnd, buffer)
EndFunction

Void Function SayHighlightedText (handle hWnd, string buffer)
var
	int iWinType,
	int iControl,
	handle hReal,
	handle hFocus,
	string sRealClass,
string sHwndClass,
	string sRealName
let iWinType = GetWindowSubtypeCode (GetCurrentWindow ())
let iControl = GetControlId (hWnd) == iD_Replace_Edit
let hReal = GetRealWindow (GetCurrentWindow ())
let hFocus = GetFocus ()
let sRealClass = GetWindowClass (hReal)
let sHwndClass = GetWindowClass (hWnd)
let sRealName = GetWindowName (hReal)
If (iGlobObj == WT_LISTBOXITEM) then
	Return ; Let ActiveItemChanged handle this
EndIf
If (sHwndClass == wcGoToTree) then
	Return ; Let ActiveItemChanged and SayTreeViewItem 
EndIf
If (sRealClass == wcDialog) then
	;wn1 = "Spell Check"
	If (sRealName == wn1) then
		If iControl then
		;(hReal != GlobalPrevReal)) then
			If (hWnd == hFocus) then
				PerformScript ReadMistakeAndSuggestion()
			EndIf
			Return
			EndIf
		EndIf
	If (iWinType != WT_COMBOBOX) then
		If (hWnd != hFocus) then
			Return
		EndIf
	EndIf
EndIf
SayHighlightedText (hWnd, buffer)
EndFunction

Void Function SayFocusedWindow ()
;Handle unknown prompts in database Properties
;the InfoBox Dll
var
	int iWinType,
	int iGlobalWinType,
	handle hCurrent,
	string sGlobalWinType,
	string sCurrentClass,
	string sParentClass
let iWinType = GetWindowSubtypeCode (GetCurrentWindow ())
let iGlobalWinType = GetWindowSubTypeCode (GlobalFocusWindow)
let hCurrent = GetCurrentWindow ()
let sGlobalWinType = GetWindowType (GlobalFocusWindow)
let sCurrentClass = GetWindowClass (hCurrent)
let sParentClass = GetWindowClass (GetParent (GetCurrentWindow ()))
If (sCurrentClass == wcNoteEdit) then
	SayWindowTypeAndText (hCurrent)
	return
EndIf
If (sCurrentClass == wcEdit) then
	If ((sParentClass == wcProperties) ||
	(sParentClass == wcProperties2)) then
		SaveCursor ()
		RouteInvisibleToPc ()
		InvisibleCursor ()
		RestrictCursor (on)
		JawsHome ()
		RestrictCursor (off)
		PriorWord ()
		SayChunk ()
		RestoreCursor ()
		SayWindowTypeAndText (GetCurrentWindow ())
		return
	EndIf
	If (iWinType == WT_EDIT) THEN
		Say (GetWindowText (GetCurrentWindow (), false), OT_TEXT)
		Return
	EndIf
EndIf
If (iGlobalWinType == WT_PASSWORDEDIT) then
	Say (msg134, OT_CONTROL_NAME) ; "Password: "
	Say (sGlobalWinType, OT_CONTROL_NAME)
	Say (GetWindowText (GlobalFocusWindow, false), OT_TEXT)
	Return
EndIf
SayObjectTypeAndText ()
EndFunction

Void Function ScreenSensitiveHelpForKnownClasses (int nObjTypeCode)
var
	string sCurrentClass
let sCurrentClass = GetWindowClass (GetCurrentWindow ())
If ((nObjTypeCode == WT_TREEVIEWITEM) ||
(nObjTypeCode == WT_TREEVIEW)) then
	Say (msg9, ot_help) ;"Tree view level "
	SayInteger (GetTreeViewLevel ())
	Say (msg10, ot_help) ;"use up or down arrow to read through the items"
	Say (msg12, ot_help) ;"use the right or left arrow keys to open or close an item"
	Say (msg13, ot_help) ;"After making your selection"
	Say (msg14, ot_help) ;"Press enter to activate or open it"
	Return
EndIf
If (nObjTypeCode == WT_BITMAP) then
	Say (msg48, OT_HELP); "This is a graphic frame"
	Say (msg49, OT_HELP); "It may contain icons linking you to other parts of Notes"
	Say (msg50, OT_HELP); "Press the left and right arrows to select the icon of your choice and press the space bar to activate"
	Say (msg51, OT_HELP); "Press the f6 key to move to the next frame"
	Return
EndIf
;For list boxes found in the Properties Boxes
;Press alt+enter from within a document, or
; from within a Tree view for an example
If (nObjTypeCode == WT_LISTBOXITEM) ||
(nObjTypeCode == WT_LISTBOX) then
	If (sCurrentClass == wcProperties) ||
	(sCurrentClass == wcProperties2) then
	Say (msg113, OT_HELP) ; "This is a list box embedded in a properties box"
	Say (msg114, OT_HELP); "Use the up and down arrows to make your selection"
		Say (msg111, OT_HELP); "Press the tab key to move to the next control"
		Return
	EndIf
EndIf
;For list boxes that are embedded in documents
;See the Edit Current Location document for an example of such list boxes
;These have no Control ID and are characteristic of embedded controls in Notes
If (nObjTypeCode == WT_LISTBOX) &&
(! GetControlId (GetCurrentWindow ())) then
	Say (msg54, OT_HELP); "This is a list box embedded in a document"
	Say (msg55, OT_HELP); "Press enter to open it"
	Say (msg56, OT_HELP); "Use the up and down arrows or the first letter of the item to make your selection"
	Say (msg57, OT_HELP); "press enter to close"
	Return;
EndIf
;For the inline Notes Browser
;Which has some of the functionality of Internet Explorer 4.x
If (nObjTypeCode == WT_HTMLBODY) then
	Say (msg58, OT_HELP); "This is the Notes Browser window"
	Say (msg59, OT_HELP); "It may contain any number of links or controls"
	Say (msg60, OT_HELP); "Press tab or shift+tab to navigate between the controls on the page"
	Say (msg61+GetScriptKeyName ("HotKeyHelp"), OT_HELP); "For a list of hot keys, press"
	Say (msg62+GetScriptKeyName ("WindowKeysHelp"), OT_HELP); "For a list of Windows keystrokes, press"
	Return
EndIf
;For links within an internet document
If (nObjTypeCode == WT_LINK) then
	Say (msg63, OT_HELP); "This is a link displayed in the Notes Browser window"
	Say (msg64, OT_HELP); "Press enter to activate it or"
	Say (msg65, OT_HELP); "Press the tab or shift+tab key to move to another link or control"
	Say (msg61+GetScriptKeyName ("HotKeyHelp"), OT_HELP); "For a list of hot keys, press"
	Say (msg62+GetScriptKeyName ("WindowKeysHelp"), OT_HELP); "For a list of Windows keystrokes, press"
	Return
EndIf
If (nObjTypeCode == WT_MULTISELECT_LISTBOX) then
	Say (msg107, OT_HELP); "This is a Multi Select List Box"
	Say (msg108, OT_HELP); "Use the up and down arrows to navigate between the items"
	Say (msg109, OT_HELP); "As you arrow up and down, you will hear whether the highlighted item is selected or not"
	Say (msg110, OT_HELP); "Press the space bar to toggle the state of the currently highlighted item"
	Say (msg111, OT_HELP); "Press the tab key to move to the next control"
	Return
EndIf
ScreenSensitiveHelpForKnownClasses (nObjTypeCode)
EndFunction

Script  ScriptFileName()
ScriptAndAppNames("Lotus Notes")
EndScript

Script ScreenSensitiveHelp ()
var 
	int iTypeCode,
	int iWinTypeCode,
	string sChildClass,
	string sClass,
	string sParentClass,
	string sAppWinName,
	string sObjName,
	string sWord
let iTypeCode = GetObjectTypeCode ()
let iWinTypeCode = GetWindowSubTypeCode (GetCurrentWindow ())
let sChildClass = GetWindowClass (GetFirstChild (GetCurrentWindow ()))
let sClass = GetWindowClass (GetCurrentWindow ())
let sParentClass = GetWindowClass (GetParent (GetCurrentWindow ()))
let sAppWinName = GetWindowName (GetAppMainWindow (GetCurrentWindow ()))
let sObjName = GetObjectName ()
let sWord = GetWord () 
If (IsSameScript ()) then
	AppFileTopic ()
	Return
EndIf
If (GlobalMenuMode > 0) then
	PerformScript ScreenSensitiveHelp ()
	Return
EndIf
If (iWinTypeCode == WT_MULTISELECT_LISTBOX) then
	ScreenSensitiveHelpForKnownClasses (WT_MULTISELECT_LISTBOX)
	Return
EndIf
;For the Date Picker, a visual representation of the calendar
If (sChildClass == wcCalClass) then
	Say (msg127, OT_HELP); "This is the Date Picker"
	Say (msg128, OT_HELP); "It is a visual representation of the calendar"
	Say (msg129, OT_HELP); "Press f6 to the Calendar View, where you can use Jaws to look at appointments scheduled for a given day"
	return
EndIf
If (iWinTypeCode == WT_TASKBAR) then
	Say (msg40, OT_HELP); "You are experiencing minor focus problems"
	Say (msg41, OT_HELP); "Please use the up and down arrows to regain the focus"
	Return
EndIf
If (sClass == wcWorkspaceList) then
	ScreenSensitiveHelpForKnownClasses (WT_LISTVIEW)
	Return
EndIf
;For the frames available when a database is open
If (sParentClass == wcTreeParent) then
	If (sClass == wcDocClass) then
		If (iTypeCode == 53) &&
		(GetColorBackground () == RgbStringToColor ("115156198")) then
			Say (msg42, OT_HELP); "This is a graphic frame"
			Say (msg43, OT_HELP); "Press the f6 key to move to the next control"
			return
		EndIf
		If (iTypeCode == wt_bitmap) then
			If (StringContains (sAppWinName, wn7)) ||
			(StringContains (sAppWinName, wn20)) then
				Say (msg120, OT_HELP); "This is a picker"
				Say (msg121, OT_HELP); "It usually points to another database, such as your address book"
				Say (msg122, OT_HELP); "Press the space bar to activate it"
				Say (msg111, OT_HELP); "Press the tab key to move to the next control"
			ElIf (!StringContains (sAppWinName, wn7)) &&
			(!StringContains (sAppWinName, wn20)) &&
			(sWord > "") then
				If (! CaretVisible ()) then
					Say (msg44, OT_HELP); "This is the Switcher frame"
					Say (msg45, OT_HELP); "It contains the icons for Mail, To-Do, and Calendar"
					Say (msg46, OT_HELP); "Press the left and right arrow keys to select the task of your choice, and press the space bar to activate"
					Say (msg47, OT_HELP); "Press the f6 key to move to the next frame"
					Return
				EndIf
			EndIf
			Return
		EndIf
	EndIf
EndIf
If (! CaretVisible ()) &&
(sClass == wcDocClass) then
	If (iTypeCode) &&
	(iTypeCode != wt_link) &&
	(iTypeCode != WT_EDIT) &&
	(iTypeCode != WT_BITMAP) &&
	(iTypeCode != 53) then
		ScreenSensitiveHelpForKnownClasses (iTypeCode)
		Return
	EndIf
	Say (msg131, OT_HELP); "This is a Read-Only document window"
	Say (msg132, OT_HELP); "Use the left and right arrows to cycle between the links and embedded objects"
	Say (msg133, OT_HELP); "Press the space bar to activate the selected link or object"
	Return
EndIf
If (GlobalTask > "") then
	Say (msg44, OT_HELP); "This is the Switcher frame"
	Say (msg45, OT_HELP); "It contains the icons for Mail, To-Do, and Calendar"
	Say (msg46, OT_HELP); "Press the left and right arrow keys to select the task of your choice, and press the space bar to activate"
	Say (msg47, OT_HELP); "Press the f6 key to move to the next frame"
	Return
EndIf
If (sClass == wcStatus) &&
(sParentClass == wcFrameParent) &&
;wn6 = "Status"
(sObjName != wn6) then 
	Say (msg44, OT_HELP); "This is the Switcher frame"
	Say (msg45, OT_HELP); "It contains the icons for Mail, To-Do, and Calendar"
	Say (msg46, OT_HELP); "Press the left and right arrow keys to select the task of your choice, and press the space bar to activate"
	Say (msg47, OT_HELP); "Press the f6 key to move to the next frame"
	Return
EndIf
;for Object types 
If (iTypeCode) then
	ScreenSensitiveHelpForKnownClasses (iTypeCode)
	Return
EndIf
;for the Tree view, when it is slightly out of focus
If ((sClass == wcTreeParent) ||
(sClass == wcGoToTree)) then
	If (! iTypeCode) then
		If (StringContains (sAppWinName, wn19)) then
			Say (msg123, OT_HELP); "This is the Calendar Line View"
			Say (msg124, OT_HELP); "use the left and right arrows to cycle through the dates"
			Say (msg125, OT_HELP); "Press down arrow to view the appointments for a given day"
			Say (msg126, OT_HELP); "Press enter to view the details of a given appointment"
			Return
		Else
			ScreenSensitiveHelpForKnownClasses (WT_TREEVIEW)
			Return
		EndIf
	EndIf
EndIf
PerformScript ScreenSensitiveHelp ()
EndScript

Script HotKeyHelp ()
var
	int iObjType,
	handle hWnd,
	string sRealName,
	string sClass
let iObjType = GetObjectTypeCode ()
let hWnd = GetCurrentWindow ()
let sRealName = GetWindowName (GetRealWindow (hWnd))
let sClass = GetWindowClass (hWnd)
If (GlobalMenuMode > 0) then
	PerformScript HotKeyHelp ()
	Return
EndIf
If (DialogActive ()) then
	;wn1 = "Spell Check"
	If (sRealName == wn1) then
		Say (msg77+GetScriptKeyName ("ReadMistakeAndSuggestion"), OT_HELP)
	EndIf
	HotKeyHelpDefaultLoop ()
	Return
EndIf
;For Database frames
Say (msg78+GetScriptKeyName ("NextFrame"), OT_HELP); "To move to the next frame, press"
;For the inline browser
If ((iObjType == WT_HTMLBODY) ||
(iObjType == WT_LINK)) then
	Say (msg66, OT_HELP); "Hot keys are as follows"
	Say (msg70 +GetScriptKeyName ("ReformatDocument"), OT_HELP); "To reformat the current web page for easier reading, press"
	Say (msg71+GetScriptKeyName ("SelectALink"), OT_HELP); "To place all the links on the current web page into a list, press"
	Say (msg67+GetScriptKeyName ("ReadCurrentScreen"), OT_HELP); "To read the current screen with the Jaws Cursor, press"
	Say (msg68+GetScriptKeyName ("ReadNextScreen"), OT_HELP); "To read the next screen with the Jaws Cursor, press"
	Say (msg69+GetScriptKeyName ("ReadPriorScreen"), OT_HELP); "To read the previous screen with the Jaws cursor, press"
	Return
EndIf
If hReadWindow then
	If (! CaretVisible ()) then
		If (IsWindowVisible (hReadWindow)) then
			Say (msg66, OT_HELP); "Hot keys are as follows"
			Say (msg67+GetScriptKeyName ("ReadCurrentScreen"), OT_HELP); "To read the current screen with the Jaws Cursor, press"
			Say (msg68+GetScriptKeyName ("ReadNextScreen"), OT_HELP); "To read the next screen with the Jaws Cursor, press"
			Say (msg69+GetScriptKeyName ("ReadPriorScreen"), OT_HELP); "To read the previous screen with the Jaws cursor, press"
			Return
		EndIf
	EndIf
EndIf
If ((iObjType == WT_TREEVIEW) ||
(iObjType == WT_TREEVIEWITEM)) then
	Say (msg66, OT_HELP); "Hot keys are as follows"
	Say (msg72+GetScriptKeyName ("SayNextCharacter") + msg73+GetScriptKeyName("SayPriorCharacter")+msg74, OT_HELP); "To open or close the active item in the tree, press"
	Say (msg75+GetScriptKeyName ("ExpandAll"), OT_HELP); "To expand all items in the tree, press"
	Say (msg76+GetScriptKeyName ("CollapseAll"), OT_HELP); "To collapse all items in the tree, press"
	Return
EndIf
PerformScript HotKeyHelp ()
EndScript

Script WindowKeysHelp ()
var
	int iObjType,
	handle hWnd,
	string sAppWinName,
	string sClass
let iObjType = GetObjectTypeCode ()
let hWnd = GetCurrentWindow ()
let sAppWinName = GetWindowName (GetAppMainWindow (GetCurrentWindow ()))
let sClass = GetWindowClass (hWnd)
Say (msg79, OT_HELP); "To hear the available shortcut keys for Lotus Notes, press and hold down the alt key"
Say (msg80, OT_HELP); "Keep the alt key down and press the letter or number of your choice"
Say (msg81, OT_HELP); "If you do not choose a hot key, when you release the alt key you will hear Menu Bar.  Tap the alt key once again to leave the Menu Bar"
;For Properties Boxes
If (sClass == wcProperties || sClass == wcProperties2) then
	Say (msg116, OT_HELP); "To close the Properties Box, press alt + enter"
	Return
EndIf
; for pickers found in documents and forms
If (sClass == wcDocClass) then
	If (iObjType == WT_BITMAP) then
		If (! CaretVisible ()) then
			;wn7 = "New Calendar Entry"
			If (StringContains (sAppWinName, wn7)) then
				Say (msg130, OT_CONTROL_NAME); "press the space bar to activate this picker"
				Return
			EndIf
		EndIf
	EndIf
EndIf
If (sClass == wcDocClass) then
	If (! CaretVisible ()) then
		Say (msg84, OT_HELP); "To locate a link or other embedded object in the document, press the left and right arrows"
		Say (msg85, OT_HELP); "To activate the selected link or object, press the space bar"
		Say (msg83, OT_HELP); "To turn Edit mode on, press control+e"
		Say (msg89, OT_HELP); "To close the window, press escape"
		Return
	ElIf (CaretVisible ()) then
		Say (msg90, OT_HELP); "To navigate between the controls, use tab and shift + tab"
		Say (msg91, OT_HELP); "In some cases, the up and down arrows will also move from field to field"
		Say (msg85, OT_HELP); "To activate the selected link or object, press the space bar"
		Say (msg82, OT_HELP); "To turn Edit mode off, press control+e"
		Say (msg89, OT_HELP); "To close the window, press escape"
		Return
	EndIf
	Return
EndIf
If (sClass == IE4Class) then
	Say (msg86, OT_HELP); "To navigate between the links and embedded controls, press tab and shift+tab"
	Say (msg87, OT_HELP); "To activate the selected link or button, press enter"
	Say (msg88, OT_HELP); "To go to a new web page, press control + l, type in the new address and press enter"
	Say (msg89, OT_HELP); "To close the window, press escape"
	Return
EndIf
PerformScript WindowKeysHelp ()
EndScript

Script  SayWindowPromptAndText()
var
	int iDChild,
	int iObjType,
	int iWinType,
	int iControl,
	int iColorBack,
	object oFocusObj,
	handle hWnd,
	string sObjType,
	string sWord,
	string sObjName,
	string sGraphName,
	string sAppWinName,
	string sCurrentClass,
	string sParentClass,
	string sClass
If (DoCustomEdits ()) then
	Return
EndIf
let iObjType = GetObjectTypeCode ()
let iWinType = GetWindowSubTypeCode (GetCurrentWindow ())
let iControl = GetControlID (GetCurrentWindow ())
let iColorBack = GetColorBackground ()
let oFocusObj = GetFocusObject (iDChild)
let hWnd = GetFocus ()
let sObjType = GetObjectType ()
let sWord = GetWord ()
let sGraphName = ""
let sObjName = GetObjectName ()
let sAppWinName = GetWindowName (GetAppMainWindow (GetCurrentWindow ()))
let sCurrentClass = GetWindowClass (GetCurrentWindow ())
let sParentClass = GetWindowClass (GetParent (GetCurrentWindow ()))
Let sClass = GetWindowClass (hWnd)
; for Tree views
If ((iObjType == WT_TREEVIEW) ||
(iObjType == WT_TREEVIEWITEM)) then
	Say (msg96, OT_STRING); "Tree view"
	;See ActiveItemChangedEvent for sample non-MSAA code and explanation
	SayTreeViewItem ()
	Return
EndIf
;For Calendar View
If (sObjType == wn18) then
	Say (msg117, OT_CONTROL_NAME); "Calendar Line View"
	SayObjectActiveItem ()
	Return
EndIf
;For certain edit windows within the To Do and Calendar Entry document forms
;These do not use MSAA, and could potentially appear in any form 
If (iControl == iDEdit2) then
	SaveCursor ()
	InvisibleCursor ()
	RouteInvisibleToPc ()
	PriorChunk ()
	SayChunk ()
	RestoreCursor ()
EndIf
If (sCurrentClass == wcEdit) then
	If ((sParentClass == wcProperties) ||
	(sParentClass == wcProperties2)) then
		SaveCursor ()
		RouteInvisibleToPc ()
		InvisibleCursor ()
		RestrictCursor (on)
		JawsHome ()
		RestrictCursor (off)
		PriorWord ()
		SayChunk ()
		RestoreCursor ()
		SayWindowTypeAndText (GetCurrentWindow ())
		return
	EndIf
EndIf
;for document windows
If (sClass == wcDocClass) then
;wn2 = "Welcome - Lotus Notes"
	If (sAppWinName == wn10) then
		;wn12 = "Subject of memo"
		If (sObjName == wn12) then
			Say (msg1, OT_CONTROL_NAME); "SUBJECT:"
			Say (msg5, OT_CONTROL_NAME)	; "edit"
			Say (GetObjectValue (), OT_STRING)
			Return
		;wn14 = "List of undisclosed people to send copies of memo"
		ElIf (sObjName == wn14) then 
			Say (msg2, OT_CONTROL_NAME); "BCC:"
			Say (msg5, OT_CONTROL_NAME); "edit"
			Say (GetObjectValue (), OT_STRING)
			Return
		;wn13 = "List of people to send a copy of the memo"
		ElIf (sObjName == wn13) then
			Say (msg3, OT_CONTROL_NAME);"Cc"
			Say (msg5, OT_CONTROL_NAME); "edit"
			Say (GetObjectValue (), OT_STRING)
			Return
		;wn15 = "List of primary people to send memo"
		ElIf (sObjName == wn15) then
			Say (msg4, OT_CONTROL_NAME);"to:"
			Say (msg5, OT_CONTROL_NAME); "edit"
			Say (GetObjectValue (), OT_STRING)
			Return
		;wn16 = "Body of message"
		ElIf (sObjName == wn16) then
			Say (msg5, OT_CONTROL_NAME); "edit"
			Return
		ElIf iObjType== WT_BITMAP then
			Say (msg6, OT_CONTROL_NAME); "embedded"
			SayObjectActiveItem ()
			Return
		Else
			SayObjectActiveItem ()	
			Return
		EndIf
	EndIf; end of Memo windows
	If (iObjType == 53) &&
	(iColorBack == RgbStringToColor ("115156198")) then
		Say (msg98, OT_CONTROL_NAME); "Graphic frame"
		If (sWord > "") then
			SayWord ()
			Return
		EndIf
	EndIf
	If (iObjType == WT_BITMAP) &&
	(! CaretVisible ()) then
		;wn7 = "New Calendar Entry"
		;If (StringContains (sAppWinName, wn7)) then
		If (! sObjName) then
			Say (msg119, OT_CONTROL_NAME); "picker"
			Return
		Else
			Say (msg98, OT_CONTROL_NAME); "Graphic frame"
			Say (sObjName, OT_CONTROL_NAME)
		EndIf
		If (sParentClass == wcTreeParent) then
			If (sAppWinName == wn2) then
				SayLine ()
			Else
				SaveCursor ()
				RouteInvisibleToPc ()
				InvisibleCursor ()
				JawsPageDown ()
				JawsEnd ()
				PriorWord ()
				SayToCursor ()
				RestoreCursor ()
			EndIf
		EndIf
		Return
	EndIf
	SayObjectActiveItem ()
	Return
EndIf
If (iWinType == WT_PASSWORDEDIT) then
	Say (msg134, OT_CONTROL_NAME) ; "Password: "
	Say (GetWindowType (GetCurrentWindow ()), OT_CONTROL_NAME)
	Say (GetWindowText (GetCurrentWindow (), false), OT_TEXT)
	Return
EndIf
SayObjectActiveItem ()
EndScript

Script SayPriorCharacter ()
var
	int iObjType,
	int iObjTemp,
	int TheObjectType,
	handle hWnd,
	string sClass
If (! IsPcCursor ()) then
	PerformScript SayPriorCharacter ()
	Return
EndIf
If (GlobalMenuMode > 0) then
	PerformScript SayPriorCharacter ()
	Return
EndIf
let iObjType = GetObjectTypeCode ()
If (iObjType == WT_TABCONTROL) ||
(iObjType == WT_RADIOBUTTON) then
	{LeftArrow}
	Return
EndIf
If ((iObjType == WT_TREEVIEW) ||
(iObjType == WT_TREEVIEWITEM)) then
	{NumPadMinus}
	PerformScript SayLine ()
	Return
EndIf
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (hWnd)
; For NotesRichText windows with links and objects.  
If (sClass == wcDocClass) then
	If (! CaretVisible ()) then
		{LeftArrow}
		Return
	Else
		{LeftArrow}
		If IsLeftButtonDown () || IsRightButtonDown () then
			SelectingText (true)
			Pause ()
			SelectingText (False)
		EndIf
		; for buttons, checkboxes and other objects
		let iObjTemp = GetObjectTypeCode ()
		If (iObjType != iObjTemp) then
			If (iObjTemp != WT_EDIT) then
				Return
			EndIf
		EndIf
		SayCharacter ()
		Return
	EndIf
EndIf
;Else
	PerformScript SayPriorCharacter ()
EndScript

Script SayNextCharacter ()
var
	int iObjType,
	int iObjTemp,
	int TheObjectType,
	handle hWnd,
	string sClass
If (! IsPcCursor ()) then
	PerformScript SayNextCharacter ()
	Return
EndIf
If (GlobalMenuMode > 0) then
	PerformScript SayNextCharacter ()
	Return
EndIf
let iObjType = GetObjectTypeCode ()
If (iObjType == WT_TABCONTROL) ||
(iObjType == WT_RADIOBUTTON) then
	{RightArrow}
	Return
EndIf
If ((iObjType == WT_TREEVIEW) ||
(iObjType == WT_TREEVIEWITEM)) then
	{NumPadPlus}
	PerformScript SayLine ()
	Return
EndIf
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (hWnd)
; For NotesRichText windows with links and objects.  
If (sClass == wcDocClass) then
	If (! CaretVisible ()) then
		{RightArrow}
		Return
	Else
		{RightArrow}
		If IsLeftButtonDown () || IsRightButtonDown () then
			SelectingText (true)
			Pause ()
			SelectingText (False)
		EndIf
		; for buttons, checkboxes and other objects
		let iObjTemp = GetObjectTypeCode ()
		If (iObjType != iObjTemp) then
			If (iObjTemp != WT_EDIT) then
				Return
			EndIf
		EndIf
		SayCharacter ()
		Return
	EndIf
EndIf
;Else
	PerformScript SayNextCharacter ()
EndScript

Script SayPriorWord ()
var
	int iObjType,
	int iObjTemp,
	handle hWnd,
	string sClass
If (! IsPcCursor ()) then
	PerformScript SayPriorWord ()
	Return
EndIf
If GlobalMenuMode > 0 then
	PerformScript SayPriorWord ()
	Return
EndIf
let iObjType = GetObjectTypeCode ()
If (iObjType == WT_TABCONTROL) then
	{control+LeftArrow}
	Return
EndIf
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (hWnd)
If (sClass == wcDocClass) then
	{Control+LeftArrow}
	If IsLeftButtonDown () || IsRightButtonDown () then
		SelectingText (true)
		Pause ()
		SelectingText (false)
	EndIf
	let iObjTemp = GetObjectTypeCode ()
; for buttons, checkboxes and other objects
	If (iObjType != iObjTemp) then
		If (iObjTemp != WT_EDIT) then
			Return
		EndIf
	EndIf
	SayWord ()
Else
	PerformScript SayPriorWord ()
EndIf
EndScript

Script SayNextWord ()
var
	int iObjTemp,
	int iObjType,
	handle hWnd,
	string sClass
If (! IsPcCursor ()) then
	PerformScript SayNextWord ()
	Return
EndIf
If (GlobalMenuMode > 0) then
	PerformScript SayNextWord ()
	Return
EndIf
let iObjType = GetObjectTypeCode ()
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (hWnd)
If (iObjType == WT_TABCONTROL) then
	{Control+RightArrow}
	Return
EndIf
If (sClass == wcDocClass) then
	{Control+RightArrow}
	If IsLeftButtonDown () || IsRightButtonDown () then
		SelectingText (true)
		Pause ()
		SelectingText (false)
	EndIf
let iObjTemp = GetObjectTypeCode ()
; for buttons, checkboxes and other objects
	If (iObjType != iObjTemp) then
		If (iObjTemp != WT_EDIT) then
			Return
		EndIf
	EndIf
	SayWord ()
Else
	PerformScript SayNextWord ()
EndIf
EndScript

Script SayPriorLine ()
If (GlobalMenuMode > 0) then
	PerformScript SayPriorLine ()
	Return
EndIf
If (IsPcCursor ()) then
	If (iGlobObj == WT_TREEVIEW) ||
	(iGlobObj == WT_TREEVIEWITEM) ||
	(iGlobObj == WT_RADIOBUTTON) then
		{UpArrow}
		return;
	EndIf
EndIf
PriorLine ()
PerformScript SayLine ()
EndScript

Script SayNextLine ()
If (GlobalMenuMode > 0) then
	PerformScript SayNextLine ()
	Return
EndIf
If (IsPcCursor ()) then
	If (iGlobObj == WT_TREEVIEW) ||
	(iGlobObj == WT_TREEVIEWITEM) ||
	(iGlobObj == WT_RADIOBUTTON) then
		{DownArrow}
		return;
	EndIf
EndIf
NextLine ()
PerformScript SayLine ()
EndScript

Script SayLine ()
var
	int iLeft,
	int iRight,
	int iTop,
	int iBottom,
	handle hFocus,
	int iObjType,
	int iWinType,
	string sObjValue,
	string sGraphName,
	string sAppWinName,
	string sWinName,
	string sCurrentClass,
	string sClass,
	string sNextClass
If GlobalMenuMode > 0 then
	PerformScript SayLine ()
	Return
EndIf
If (! IsPcCursor ()) then
	PerformScript SayLine ()
	Return
EndIf
If IsEmbeddedControl () then
	If (iGlobObj == WT_LISTBOX || iGlobObj == WT_COMBOBOX) then
			If (sClass == wcProperties) ||
			(sClass == wcProperties2) then
				SayObjectActiveItem ()
				Return
			EndIf
		let sObjValue = GetObjectValue ()
		Say (sObjValue, OT_LINE)
	Else
		SayObjectActiveItem ()
	EndIf
	Return
EndIf
let hFocus = GetFocus ()
let sClass = GetWindowClass (hFocus)
If (StringContains (GetWindowName (GetRealWindow (GetFocus ())), wn19)) then
	If (sClass == wcTreeParent) then
		SayObjectActiveItem ()
		Return
	EndIf
EndIf
let iWinType = GetWindowSubTypeCode (GetCurrentWindow ())
let sGraphName = ""
let sAppWinName = GetWindowName (GetAppMainWindow (GetFocus ()))
let sCurrentClass = GetWindowClass (GetCurrentWindow ())
let sNextClass = GetWindowClass (GetNextWindow (GetFocus ()))
If (sClass == wcNoteEdit) then
	let sWinName = GetWindowName (hFocus)
	; the following code block is to special-case the message headers
	; which by default do not behave properly when multiple lines are present
	If ((sWinName == wn22) ||
	(sWinName == wn23) ||
	(sWinName == wn24) ||
	(sWinName == wn25)) then
		Say (sWinName, OT_CONTROL_NAME)
		Say (GetWindowType (hFocus), OT_CONTROL_NAME)
		SaveCursor ()
		RouteInvisibleToPc ()
		InvisibleCursor ()
		RestrictCursor (on)
		SayLine ()
		RestrictCursor (off)
		RestoreCursor ()
		Return
	EndIf
	SayLine ()
	Return
EndIf
If (GlobalTask > "") &&
(StringContains (GlobalTask, wn5)) then
	Say (GlobalTask, OT_CONTROL_NAME)
	Return
EndIf
;For the Welcome Page
	;wn2 = "Welcome - Lotus Notes"
let iObjType = GetObjectTypeCode ()
	If (sAppWinName == wn2) then
		If (iObjType == WT_LISTBOX) then
			let sObjValue = GetObjectValue ()
			Say (sObjValue, OT_LINE)
			return
		EndIf
EndIf
If (sCurrentClass == wcDocClass) then
	If (iObjType == WT_BITMAP) then
		;wn7 = "New Calendar Entry"
		If (StringContains (sAppWinName, wn7)) then
			Say (msg119, OT_CONTROL_NAME); "picker"
			Return
		EndIf
	EndIf
EndIf
;for MultiLine edits
If (GetObjectRect (iLeft, iRight, iTop, iBottom)) then ; is this necessary?
	If (sClass == wcDocClass) then
		If (iObjType == WT_EDITCOMBO) then
			let sObjValue = GetObjectValue ()
			Say (sObjValue, OT_LINE)
			Return
		EndIf
	/*if globalEnterPressed then
		let sObjValue = GetChunk()
		if !StringLength(sObjValue) then
			; sometimes the pc cursor is in a blank spot that becomes space when refresh
			RefreshWindow (GetCurrentWindow())
			let sObjValue = GetChunk()
			endif
			if !StringLength(sObjValue) then
			; didn't get it with pc, try to get it with invisible since pc might be at the end of line
				SaveCursor()
				RouteInvisibleToPC()
				InvisibleCursor()
				MoveTo (GetCursorCol()-3,GetCursorRow())
				let sObjValue = GetChunk()
				RestoreCursor()
			EndIf
		else
			let sObjValue = GetObjectValue ()
		EndIf
		If (StringLength (sObjValue) > 0) then
			Say (sObjValue, OT_LINE)
		Else
			Say (msg141, OT_LINE); "blank"
		EndIf*/
		SaveCursor ()
		RouteInvisibleToPc ()
		InvisibleCursor ()
		RestrictCursor (on)
		SayLine ()
		RestrictCursor (off)
		RestoreCursor ()
		Return
	EndIf
EndIf
;for reading document status in Tree views
;See ActiveItemChangedEvent for sample non-MSAA code and explanation
If (iObjType == WT_TREEVIEW) ||
(iObjType == WT_TREEVIEWITEM) then
	SayTreeViewItem ()
	Return
EndIf
If (iWinType == WT_PASSWORDEDIT) then
	Say (msg134, OT_CONTROL_NAME) ; "Password: "
	Say (GetWindowType (GetCurrentWindow ()), OT_CONTROL_NAME)
	Say (GetWindowText (GetCurrentWindow (), false), OT_TEXT)
	Return
EndIf
PerformScript SayLine ()
EndScript

Script Enter ()
let globalEnterPressed = TRUE
PerformScript Enter ()
EndScript

Script SayCharacter ()
var
	int iObjType,
	string sAppWinName,
	string sCurrentClass
let iObjType = GetObjectTypeCode ()
let sAppWinName = GetWindowName (GetAppMainWindow (GetCurrentWindow ()))
let sCurrentClass = GetWindowClass (GetCurrentWindow ())
If GlobalMenuMode > 0 then
	PerformScript SayCharacter ()
	Return
EndIf
If IsEmbeddedControl () then
	SayObjectActiveItem ()
	Return
EndIf
If (IsPcCursor ()) then 
	If (GlobalTask > "") &&
		(StringContains (GlobalTask, wn5)) then
		Say (GlobalTask, OT_CONTROL_NAME)
		Return
	EndIf
EndIf
If (iObjType == wt_TabControl) then
	SayObjectActiveItem ()
	Return
EndIf
If (sCurrentClass == wcDocClass) then
	If (iObjType == WT_BITMAP) &&
	(! CaretVisible ()) then
		;wn7 = "New Calendar Entry"
		If (StringContains (sAppWinName, wn7)) then
			Say (msg119, OT_CONTROL_NAME); "picker"
			Return
		EndIf
	EndIf
EndIf
PerformScript SayCharacter ()
EndScript

Script SayWord ()
var
	int iObjType,
	string sAppWinName,
	string sCurrentClass
let iObjType = GetObjectTypeCode ()
let sAppWinName = GetWindowName (GetAppMainWindow (GetCurrentWindow ()))
let sCurrentClass = GetWindowClass (GetCurrentWindow ())
If GlobalMenuMode > 0 then
	PerformScript SayWord ()
	Return
EndIf
If IsEmbeddedControl () then
	If (IsSameScript ()) then
		SpellString (GetObjectName ())
		AddHook (hk_script, "SpellWordHook")
		Return
	EndIf
	SayObjectActiveItem ()
	Return
EndIf
If (IsPcCursor ()) then 
	If GlobalMenuMode == 0 then
		If (GlobalTask > "") &&
		(StringContains (GlobalTask, wn5)) then
			If IsSameScript () then
				SpellString (GlobalTask)
				AddHook (hk_script, "SpellWordHook")
				Return
			EndIf
			Say (GlobalTask, OT_CONTROL_NAME)
			Return
		EndIf
	EndIf
EndIf
If (iObjType == wt_TabControl) then
	If IsSameScript () Then
		SpellString (GetObjectName ())
		AddHook (HK_SCRIPT, "SpellWordHook")
		Return
	EndIf
	SayObjectActiveItem ()
	Return
EndIf
If (sCurrentClass == wcDocClass) then
	If (iObjType == WT_BITMAP) &&
	(! CaretVisible ()) then
		;wn7 = "New Calendar Entry"
		If (StringContains (sAppWinName, wn7)) then
			Say (msg119, OT_CONTROL_NAME); "picker"
			Return
		EndIf
	EndIf
EndIf
PerformScript SayWord ()
EndScript

Script JawsBackspace ()
var
	int TheObjType
Let TheObjType = GetObjectTypeCode ()
If ((TheObjType == WT_TREEVIEW) ||
(TheObjType == WT_TREEVIEWITEM)) then
	{NumPadMinus}
	Return
EndIf
PerformScript JawsBackspace ()
EndScript

Script ExpandAll ()
{shift+NumPadPlus}
Say (msg15, OT_MESSAGE); "expand all"
EndScript

Script CollapseAll ()
{shift+NumPadMinus}
Say (msg16, OT_MESSAGE); "collapse all"
EndScript

Script ReadMistakeAndSuggestion ()
var
	handle hReal,
	handle hWnd,
	string sRealName
let hReal = GetRealWindow (GetFocus ())
let sRealName = GetWindowName (hReal)
If ((DialogActive ()) &&
;wn1 = "Spell Check"
(sRealName == wn1)) then
	SaveCursor ()
	InvisibleCursor ()
	let hWnd = FindDescendantWindow (hReal, iD_Replace_Edit)
	MoveToWindow (hWnd)
	SayWindowTypeAndText (hWnd)
	SpellString (GetWindowText (hWnd, false))
	let hWnd = FindDescendantWindow (hReal, iD_Guess_list)
	MoveToWindow (hWnd)
	If (! GetWindowText (hWnd, false)) then
		Say (msg20, OT_MESSAGE); "No suggestions"
		Return;
	ElIf (! GetWindowText (hWnd, true)) then
		Say (msg19, OT_MESSAGE); "No suggestion is highlighted"
		Return;
	Else
		Say (msg18, OT_MESSAGE); "Guess: ListBox"
		Say (GetWindowText (hWnd, true), OT_STRING)
		SpellString (GetWindowText (hWnd, true))
	EndIf
	Return
EndIf
Say (msg21, OT_MESSAGE); "Not in spellChecker"
EndScript

Script ReadCurrentScreen ()
var
	string sCurrentClass
If (hReadWindow) &&
(IsWindowVisible (hReadWindow)) then
	Pause ()
	JawsCursor ()
	MoveToWindow (hReadWindow)
	RestrictCursor (on)
	JawsCursor ()
	SayAll ()
	RestrictCursor (off)
	Return
Else
	Say (msg22, OT_MESSAGE); "Not in Help Topic window"
EndIf
EndScript

Script ReadNextScreen ()
let ignoreNewText = true
RestrictCursor (off)
{PageDown}
PerformScript ReadCurrentScreen ()
let ignoreNewText = false
EndScript

Script ReadPriorScreen ()
let ignoreNewText = true
RestrictCursor (off)
{PageUp}
PerformScript ReadCurrentScreen ()
let ignoreNewText = false
EndScript

Script ReformatDocument ()
if (ieReformatBody (GetFocus ())) then
	Say(msg25, ot_message); "Reformatting document, please wait"
else
	Say(msg24, ot_message); "Reformatting failed.  Document may not have finished loading"
Endif
EndScript

Script SelectALink ()
var
	object doc,
	object links,
	object all,
	int nLinks,
int nElement,
	string buffer,
	string strTemp,
	int nIdx
let doc = ieGetCurrentDocument ()
let nElement = ieGetFocus()
let all = doc.all()
if (all(nElement).tagname == "frame") then
let nIdx =  GetFrameNumber(all,nElement)
let doc = doc.Frames(nIdx).document()
EndIf
let links = doc.links
let all = doc.all
let nLinks = links.length
if (nLinks == 0) then
	Say(msg26, ot_message); "No links found in document"
	return
endif
let nIdx = 0
while (nIdx < nLinks)
	let strTemp = links(nIdx).InnerText
	if (!strTemp) then
		let strTemp = all(links(nIdx).SourceIndex+1).alt
	endif
	if (!strTemp) then
		let strTemp = links(nIdx).href
	endif
	let buffer = buffer + "\007" + strTemp
	let nIdx = nIdx+1
endwhile
let nIdx = DlgSelectItemInList (buffer, SelectALinkDialogName, false)
if (nIdx == 0) then
	return
endif
doc.links(nIdx-1).focus
doc.links(nIdx-1).click
EndScript

Script FocusToBrowser ()
var
	handle hFocus
let hFocus = GetFocus ()
If (hBrowseWindow == hFocus) then
	Say (msg29, OT_MESSAGE); "The browser window already has focus"
	return
EndIf
If (hBrowseWindow) then
	AutoFocusBrowser ()
else
	Say (msg27, OT_MESSAGE); "Browser not visible on the screen"
EndIf
EndScript

Script NextFrame ()
var
	int iObjType,
	int iScreenEcho,
	int iSet,
	int iVerbosity,
	string sChildClass
let iObjType = GetObjectTypeCode ()
let iScreenEcho = GetJcfOption (OPT_SCREEN_ECHO)
let iVerbosity = GetVerbosity ()
let iSet = iVerbosity
let sChildClass = GetWindowClass (GetFirstChild (GlobalFocusWindow))
{f6}
;To accurately keep OverChatter from happening when in frames that do not change the window handle
Say (msg112, OT_STRING); "Next Frame"
Pause ()
If (sChildClass == wcCalClass) ||
(iObjType == 53) then
	Return
EndIf
While (iSet < 2)
	VerbosityLevel ()
	let iSet = GetVerbosity ()
EndWhile
SetJcfOption (OPT_SCREEN_ECHO, 0)
ActivateMenuBar ()
ActivateMenuBar ()
Pause ()
let iSet = GetVerbosity ()
while (iSet != iVerbosity)
	VerbosityLevel ()
	let iSet = GetVerbosity ()
	SpeechOn ()
EndWhile
SetJcfOption (OPT_SCREEN_ECHO, iScreenEcho)
EndScript

Script JawsPageDown ()
let IgnoreNewText = false
PerformScript JawsPageDown()
EndScript

Script JawsPageUp ()
let IgnoreNewText = false
PerformScript JawsPageUp()
EndScript

Script RefreshScreen ()
let IgnoreNewText = false
PerformScript RefreshScreen()
EndScript

Script ContextSensitiveHelp ()
var
	int iMSAAMode,
	string TheText
If (IsWindowVisible (hContext)) then
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (hContext)
	let TheText = GetWindowText (GetCurrentWindow (), false)
	SayWindow (GetCurrentWindow (), Read_Everything)
	RestoreCursor ()
Else
	let iMSAAMode = GetJcfOption (OPT_MSAA_MODE)
		SetJcfOption (OPT_MSAA_MODE, 2)
		let TheText = GetObjectName ()
		If (StringLength (TheText) > 0) then
			Say (TheText, OT_HELP)
		Else
		Say (msg140, OT_HELP); "No Help Found for this control"
	EndIf
EndIf
EndScript

Script JawsDelete ()
If (GlobalMenuMode > 0) then
	PerformScript JawsDelete ()
	Return
EndIf
If (! CaretVisible ()) then
	{delete}
	Return
EndIf
PerformScript JawsDelete ()
EndScript
